<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contract extends Model 
{

    protected $table = 'contracts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contractType()
    {
        return $this->hasOne('ContractType');
    }

    public function buildingType()
    {
        return $this->hasOne('BuildingType');
    }

    public function language()
    {
        return $this->hasOne('Languages');
    }

    public function building()
    {
        return $this->hasOne('App\Model\Building');
    }

}